#version 330 core
out vec4 FragColor;

uniform sampler2D mainImage;
uniform vec3 fade;
uniform float act;
in vec2 texPosition;

vec3 blur(sampler2D t, vec2 uv, int n) {
	vec3 c = vec3(0.0);
	float rf = 1.0, gf = 1.0, bf = 1.0;
	float dist = length(uv);
	for(int i = 0; i < n; i++){
		c.r += texture(t, 0.5 + 0.5 * (uv * rf)).r;
		c.g += texture(t, 0.5 + 0.5 * (uv * gf)).g;
		c.b += texture(t, 0.5 + 0.5 * (uv * bf)).b;
		
		rf *= 0.996;
		gf *= 0.9982;
        bf *= 0.9982;
		
	}
	return c / n;
}

vec2 barrelDistortion(vec2 p, float d) {
	vec2 uv = p * 2.0 - 1.0;
	float theta  = atan(p.y, p.x);
    float radius = length(p);
    radius = pow(radius, d);
    p.x = radius * cos(theta);
    p.y = radius * sin(theta);
    return 0.5 * (p + 1.0);
}

void main(void) {
	vec4 mainPixel = texture(mainImage, texPosition);
	if(act == 1) {
		vec2 center = texPosition * 2.0 - 1.0;
		float depth = mainPixel.a;
		float offset = 0.1 * smoothstep(0.50, 1.5, length(center));
		vec4 color1 = texture(mainImage, texPosition + vec2(offset, 0.0));
		vec4 color2 = texture(mainImage, texPosition + vec2(0.0, -offset));
		vec4 color3 = texture(mainImage, texPosition + vec2(-offset, 0.0));
		vec4 color4 = texture(mainImage, texPosition + vec2(0.0, offset));
		mainPixel =  mod(gl_FragCoord.y, 3.0) * (color1 + color3 + color3 + color4 + mainPixel) / 15.0;
		mainPixel += smoothstep (0.0, 1.0, depth) * 1.4;	
	}
	else if(act == 6) {
		vec2 center = texPosition * 2.0 - 1.0;
		mainPixel = vec4(blur(mainImage, center, 20), 1.0);
		float depth = mainPixel.a;
		mainPixel *= mod(gl_FragCoord.y, 3.0);	
	}
	else if(act == 7) {
		vec2 center = texPosition * 2.0 - 1.0;
		mainPixel = vec4(blur(mainImage, center, 15), 1.0);
		float depth = mainPixel.a;
		mainPixel *= mod(gl_FragCoord.y, 3.0);	
	}
	else if(act == 8) {
		vec2 center = texPosition * 2.0 - 1.0;
		mainPixel = vec4(blur(mainImage, center, 5), 1.0);
		float depth = mainPixel.a;
		mainPixel *= mod(gl_FragCoord.y, 3.0);	
	}
	mainPixel = pow(mainPixel, vec4(1.0 / 1.2));
	gl_FragColor = mainPixel * vec4(fade, 1.0);
}